//=============================================================================
// MountainDewVoltage2. upgraded to recharge 10x more bio
//=============================================================================
class MountainDewVoltage2 extends DeusExPickup;

var int rechargeAmount;
var int HealAmount;
var int mpRechargeAmount;

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot == 9);
}

state Activated
{
	function Activate()
	{
		// can't turn it off
	}

	function BeginState()
	{
		local DeusExPlayer player;
		
		Super.BeginState();

		player = DeusExPlayer(Owner);
		if (player != None)
			player.HealPlayer(HealAmount, False);;
			player.Energy += rechargeAmount; //whoo, open room for energy glitching!

		PlaySound(sound'MedicalHiss');
		UseOnce();
	}
Begin:
}

defaultproperties
{
     rechargeAmount=1000
     healAmount=75
     mpRechargeAmount=1000
     maxCopies=6
     bCanHaveMultipleCopies=True
     InventoryGroup=157
     bActivatable=True
     ItemName="Mountain Dew Voltage"
     ItemArticle="some"
     largeIconHeight=64
     largeIconWidth=64
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Sodacan'
     PickupViewMesh=LodMesh'DeusExItems.Sodacan'
     ThirdPersonMesh=LodMesh'DeusExItems.Sodacan'
     LandSound=Sound'DeusExSounds.Generic.MetalHit1'
     Icon=Texture'Markistan.Icons.BeltIconMD5'
     Description="This is a can of awesome. Voltage Edition, blue raspberry flavor."
     beltDescription="DEW VLTG"
     Skin=Texture'Markistan.Skins.MountainDewTex4'
     Mesh=LodMesh'DeusExItems.Sodacan'
     CollisionRadius=3.000000
     CollisionHeight=4.500000
     Mass=5.000000
     Buoyancy=3.000000
}
